----------------
title : C++ 레퍼런스 - string 의 replace 함수
cat_title :  replace
ref_title : replace, basic_string::replace
path : /C++ Reference/string
publish_date : 2020-07-17
---------------

##@ cpp-ref-start

#@ replace

문자열의 일부를 다른 문자열로 치환한다. 아래와 같이 다양한 형태의 오버로딩이 존재한다.

```cpp-formatted
basic_string& replace(size_type pos, size_type count, const basic_string& str);
basic_string& replace(const_iterator first, const_iterator last,
                      const basic_string& str);
```

기존 문자열의 `pos` 부터 `count` 개의 문자들을, 혹은 `first` 부터 `last` 전 까지의 문자들을 `str` 로 치환한다.

```cpp-formatted
basic_string& replace(size_type pos, size_type count, const basic_string& str,
                      size_type pos2, size_type count2 = npos);
```

기존 문자열의 `pos` 부터 `count` 개의 문자들을 `str` 의 `pos2` 부터 `count2` 개의 문자들로 치환한다.

```cpp-formatted
template <class InputIt>
basic_string& replace(const_iterator first, const_iterator last, InputIt first2,
                      InputIt last2);
```

기존 문자열의 `first` 부터 `last` 를 `first2` 부터 `last2` 로 치환한다.

```cpp-formatted
basic_string& replace(size_type pos, size_type count, const CharT* cstr,
                      size_type count2);
basic_string& replace(const_iterator first, const_iterator last,
                      const CharT* cstr, size_type count2);
```

기존 문자열의 `pos` 부터 `count` 개의 문자를, 혹은 `first` 부터 `last` 까지의 문자를 `cstr` 이 가리키는 배열의 `count2` 개 만큼의 문자들로 치환한다. 이 때 `cstr` 이 가리키는 문자 배열은 널 문자를 포함하고 있어도 괜찮다.

```cpp-formatted
basic_string& replace(size_type pos, size_type count, const CharT* cstr);
basic_string& replace(const_iterator first, const_iterator last,
                      const CharT* cstr);
```

기존 문자열의 `pos` 부터 `count` 개의 문자를, 혹은 `first` 부터 `last` 까지의 문자를 `cstr` 이 가리키는 널 종료 문자열로 치환한다.

```cpp-formatted
basic_string& replace(size_type pos, size_type count, size_type count2,
                      CharT ch);
basic_string& replace(const_iterator first, const_iterator last,
                      size_type count2, CharT ch);
```

기존 문자열의 `pos` 부터 `count` 개의 문자를, 혹은 `first` 부터 `last` 까지의 문자를 `ch` 문자 `count2` 개로 치환한다.

```cpp-formatted
basic_string& replace(const_iterator first, const_iterator last,
                      std::initializer_list<CharT> ilist);
```

기존 문자열의 `first` 부터 `last` 까지의 문자들을 `ilist` 에 있는 문자들로 바꾼다.

```cpp-formatted
template <class T>
basic_string& replace(size_type pos, size_type count, const T& t);
template <class T>
basic_string& replace(const_iterator first, const_iterator last, const T& t);
template <class T>
basic_string& replace(size_type pos, size_type count, const T& t,
                      size_type pos2, size_type count2 = npos);
```

기존 문자열의 `pos` 부터 `count` 개 만큼, 혹은 `first` 부터 `last` 까지를 `string_view` 로 변환 가능한 타입 `t` 로 치환한다. 이 때  `t` 는 `std::is_convertible_v<const T&, std::basic_string_view<CharT, Traits>>` 를 만족해야 하며, `std::is_convertible_v<const T&, const CharT*>` 는 거짓이어야 한다.

### 인자들

* `pos`	-	어느 부분 부터 치환할 것인지
* `count`	-	얼마의 길이의 문자열을 치환할 것인지
* `first, last`	-	치환될 문자들의 범위
* `str`	-	어떤 문자열로 치환할 것인지
* `pos2`	-	치환할 문자열의 시작 위치
* `count2`	-	치환할 문자열의 길이
* `cstr`	-	치환할 문자열을 가리키는 포인터
* `ch`	-	치환할 문자
* `first2, last2`	-	치환할 문자열의 범위
* `ilist`	-	치환할 문자열의 초기화자 리스트
* t	`- string_view` 로 변환 가능한 치환할 문자열

### 리턴값

`*this` 가 리턴된다.

### 실행 예제

```cpp-formatted
#include <iostream>
#include <string>

int main() {
  std::string base = "this is a test string.";
  std::string str2 = "n example";
  std::string str3 = "sample phrase";
  std::string str4 = "useful.";

  // replace signatures used in the same order as described above:

  // Using positions:                 0123456789*123456789*12345
  std::string str = base;            // "this is a test string."
  str.replace(9, 5, str2);           // "this is an example string." (1)
  str.replace(19, 6, str3, 7, 6);    // "this is an example phrase." (2)
  str.replace(8, 10, "just a");      // "this is just a phrase."     (3)
  str.replace(8, 6, "a shorty", 7);  // "this is a short phrase."    (4)
  str.replace(22, 1, 3, '!');        // "this is a short phrase!!!"  (5)

  // Using iterators: 0123456789*123456789*
  str.replace(str.begin(), str.end() - 3, str3);  // "sample phrase!!!"      (1)
  str.replace(str.begin(), str.begin() + 6,
              "replace");  // "replace phrase!!!"     (3)
  str.replace(str.begin() + 8, str.begin() + 14, "is coolness",
              7);  // "replace is cool!!!"    (4)
  str.replace(str.begin() + 12, str.end() - 4, 4,
              'o');  // "replace is cooool!!!"  (5)
  str.replace(str.begin() + 11, str.end(), str4.begin(),
              str4.end());  // "replace is useful."    (6)
  std::cout << str << '\n';
  return 0;
}
```

실행 결과

```exec
replace is useful.
```

### 참고 자료

* `substr` : 문자열의 일부를 리턴한다.
* `find` : 문자열을 검색한다.
* `insert` : 문자를 삽입한다.